/** @type {import('tailwindcss').Config} */
const defaultTheme = require('tailwindcss/defaultTheme')
const plugin = require('tailwindcss/plugin')
const colors = require("tailwindcss/colors")
module.exports = {
  important: false,
  darkMode: 'class',
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
    "./node_modules/vue-tailwind-datepicker/**/*.js"
    
  ],
  
  theme: {
     
    extend: {
      fontFamily: {
        sans: ['Montserrat', ...defaultTheme.fontFamily.sans], 
      },
      colors: {
        "vtd-primary": colors.sky,
        "vtd-secondary": colors.gray,
        'red': '#f00000',
        blue: {        
          '900': '#0072EF',
          '1000': '#0061CC',
        },
        black: {
          '900': '#021129',
         
        },
        red: {
          '600': '#e02424',
        },
        teal: {
          '100': '#d5f5f6',          
          '500': '#0694a2',
          
        },
        primary: {
          50: "#F6F8FF",
          100: "#EDF0FF",
          200: "#D1DAFE",
          300: "#B4C2FD",
          400: "#8092FF",
          500: "#4669FA",
          600: "#3F5EDF",
          700: "#2A3F96",
          800: "#203071",
          900: "#151F49",
        },
      },

      dropShadow: {
        'form-shadow': [
            '0 0px 10px rgba(0, 0, 0, 0.05)',
        ]
      }

 
    },
  },
  plugins: [
    // require('@tailwindcss/forms'),
  ],
}

