<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Patch(
 *     path="/verify-otp",
 *     tags={"User Profile"},
 *     summary="It updates mobile number OR email address right after OTP verified.",
 *     operationId="verifyOTP",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                      "user_type",
 *                      "verification_for", 
 *                      "otp"
 *                 },
 *                 @OA\Property(
 *                     property="user_type", 
 *                     type="integer",
 *                     description="1 = Customer , 2 = Driver"
 *                 ),
 *                 @OA\Property(
 *                     property="verification_for", 
 *                     type="string",
 *                     enum={"email", "mobile"}
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                     example="+91",
 *                     description="Its required when type = mobile"
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                     description="Its required when type = mobile"
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                     description="Its required when type = email"
 *                 ),
 *                 @OA\Property(
 *                     property="otp", 
 *                     type="integer",
 *                     format="int32"
 *                 )
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=401, ref="#/components/responses/Unauthorized"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

class VerifyOTP
{
    
}
