<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/update_vehicle_info",
 *     tags={"Driver Authentication"},
 *     summary="submit driver vehicle info.",
 *     operationId="vehicleInfo",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 @OA\Property(
 *                     property="vehicle_type", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="plate_number", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="model_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="model_no", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="color", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="identification_no", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="model_year", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="seating_capacity", 
 *                     type="integer",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="VehicleInfoResponse",
 *   type="string",
 * )
 */

class VehicleInfo
{
}
