<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/update_vehicle_images",
 *     tags={"Driver Authentication"},
 *     summary="submit driver vehicle images.",
 *     operationId="vehicleImage",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 @OA\Property(
 *                     property="registration_proof_file", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="insurance_proof_file", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="vehicle_front_image", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="vehicle_back_image", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="vehicle_right_image", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="vehicle_left_image", 
 *                     type="string",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="VehicleImageResponse",
 *   type="string",
 * )
 */

class VehicleImage
{
}
