<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/user/update_profile",
 *     tags={"User Profile"},
 *     summary="Update the user's profile info.",
 *     operationId="userProfileUpdate",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *      @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 
 *                 @OA\Property(
 *                     property="name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="profile_photo", 
 *                     type="string",
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/UserProfileUpdateResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * @OA\Schema(
 *   schema="UserProfileUpdateResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/UserProfileUpdate"
 *          )
 *      )
 *   }
 * )
 * 
 */

 class UserProfileUpdate { }