<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/user/profile",
 *     tags={"User Profile"},
 *     summary="Get the user's profile info.",
 *     operationId="userProfile",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 * 
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/UserProfileResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * @OA\Schema(
 *   schema="UserProfileResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/UserProfileData"
 *          )
 *      )
 *   }
 * )
 * 
 * @OA\Schema(
 *   schema="UserProfileData",
 *   type="object",
 *   allOf={
 *   @OA\Schema(
 *          @OA\Property(
 *              property="user", 
 *              type="object",
 *              ref="#/components/schemas/UserProfile"
 *          )
 *     )
 *   }
 * )
 */

 class UserProfile { }