<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Put(
 *     path="/user/update_address/{id}",
 *     tags={"User Addresses"},
 *     summary="Update the user address.",
 *     operationId="updateUserAddress",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="id",
 *         description="id of a address that you want to update.",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *         )
 *     ),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "apartment_name",
 *                        "street_address",
 *                        "city",
 *                        "postal_code",
 *                        "address_type",
 *                        "add_lat",
 *                        "add_long"
 *                      },               
 *                 @OA\Property(
 *                     property="apartment_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="street_address", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="city", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="postal_code", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="address_type", 
 *                     type="integer",
 *                     description="1=home,2=office,3=other",
 *                 ),
 *                 @OA\Property(
 *                     property="add_lat", 
 *                     type="number",
 *                 ),
 *                 @OA\Property(
 *                     property="add_long", 
 *                     type="number",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="UpdateUserAddressResponse",
 *   type="string",
 * )
 */

class UpdateUserAddress
{
}
