<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/update_quote_status",
 *     tags={"Air Transportation Module"},
 *     summary="Update the received quotes status by accept/counter/reject.",
 *     operationId="updateQuoteStatus",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"id","status"},
 *                 @OA\Property(
 *                     property="id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="status", 
 *                     type="integer",
 *                     description="1=accept, 2=counter, 3=reject"
 *                 ),                
 *                 @OA\Property(
 *                     property="quote_price", 
 *                     type="number",
 *                     format="float"
 *                 ),
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class UpdateQuoteStatus { }