<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/update_location",
 *     tags={"Settings"},
 *     summary="Update the user/driver location.",
 *     operationId="updateLocation",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"latitude","longitude"},
 *                 @OA\Property(
 *                     property="latitude", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="longitude", 
 *                     type="string",
 *                     
 *                 ),                
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class UpdateLocation { }