<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/update_profile",
 *     tags={"Driver Profile"},
 *     summary="Update the driver's profile info.",
 *     operationId="driverProfileUpdate",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *      @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 
 *                 @OA\Property(
 *                     property="full_name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="profile_photo", 
 *                     type="string",
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/UpdateDriverProfileResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 *  @OA\Schema(
 *   schema="UpdateDriverProfileResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/UserProfileUpdate"
 *          )
 *      )
 *   }
 * )
 */

 class UpdateDriverProfile { }
