<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Patch(
 *     path="/driver/update-password",
 *     tags={"Driver Profile"},
 *     summary="Update the driver password.",
 *     operationId="updateDriverPassword",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"password", "new_password"},
 *                 @OA\Property(
 *                     property="password", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="new_password", 
 *                     type="string",
 *                 )
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=401, ref="#/components/responses/Unauthorized"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

class UpdateDriverPassword
{
    
}
