<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/update_current_ride_status",
 *     tags={"Booking Module"},
 *     summary="Update the current ride status i.e pickup/start journey/finish journey.",
 *     operationId="updateCurrentRideStatus",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"booking_id","status"},
 *                 @OA\Property(
 *                     property="booking_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="status", 
 *                     type="integer",
 *                     description="2=to start scheduled ride, 3=arrived, 4=pickup, 5=start journey, 6=finish journey"
 *                 ),                
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class UpdateCurrentRideStatus { }