<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/update_bid_status",
 *     tags={"Bids"},
 *     summary="Update the received bid status by accept/counter/reject.",
 *     operationId="updateBidStatus",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"booking_id","status"},
 *                 @OA\Property(
 *                     property="booking_id", 
 *                     type="integer",
 *                     format="int64",
 *                 ),
 *                 @OA\Property(
 *                     property="driver_id", 
 *                     type="integer",
 *                     format="int64",
 *                 ),
 *                 @OA\Property(
 *                     property="status", 
 *                     type="integer",
 *                     description="0=bid, 1=accept, 2=user counter, 3=driver counter, 4=reject"
 *                 ),                
 *                 @OA\Property(
 *                     property="bid_price", 
 *                     type="number",
 *                     format="float"
 *                 ),
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class UpdateBidStatus { }