<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/subscribe",
 *     tags={"Subscriptions"},
 *     summary="Subscribe driver to plan.",
 *     operationId="driverSubscribe",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *      @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                      "plan_id","card_token" 
 *                 },
 *                 @OA\Property(
 *                     property="plan_id", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="card_token", 
 *                     type="string",
 *                 ),
 *             )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class SubscribeDriver { }