<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/social-login",
 *     tags={"User Authentication"},
 *     summary="Make the user login using socialite.",
 *     operationId="socialLogin",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"social_id", "social_type", "device_name", "device_type", "device_id"},
 *                 @OA\Property(
 *                     property="social_id", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="social_type", 
 *                     type="integer",
 *                     description="0=Normal, 1=Google, 2=Facebook, 3=Twitter, 4=Apple"
 *                 ),
 *                 @OA\Property(
 *                     property="device_type", 
 *                     type="string", 
 *                     enum={"ios","android","web"},
 *                 ),
 *                 @OA\Property(
 *                     property="device_name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_id", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_token", 
 *                     type="string"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/LoginResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class SocialLogin { }