<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Patch(
 *     path="/send-otp",
 *     tags={"User Profile"},
 *     summary="It sends the OTP on mobile number OR email address you want to update.",
 *     operationId="sendOTP",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                      "verification_for","user_type" 
 *                 },
 *                 @OA\Property(
 *                     property="user_type", 
 *                     type="integer",
 *                     description="1 = Customer , 2 = Driver"
 *                 ),
 *                 @OA\Property(
 *                     property="verification_for", 
 *                     type="string",
 *                     enum={"email", "mobile"}
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                     example="+91",
 *                     description="Its required when type = mobile"
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                     description="Its required when type = mobile"
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                     description="Its required when type = email"
 *                 )
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=401, ref="#/components/responses/Unauthorized"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

class SendOTP
{
    
}
