<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/send_help_request",
 *     tags={"Settings"},
 *     summary="send help request.",
 *     operationId="sendHelpRequest",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "help_reason_id",
 *                        "description",
 *                      },
 *                 @OA\Property(
 *                     property="help_reason_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="description", 
 *                     type="string",
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="SendHelpRequestResponse",
 *   type="string",
 * )
 */

class SendHelpRequest
{
}
