<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/driver_searching",
 *     tags={"Booking Module"},
 *     summary="Get the booking status for searching drivers .",
 *     operationId="driverSearching",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetSearchResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetSearchResponse",
 *   type="object",
 *   allOf={
 *    
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetSearchResponseData"
 *          )
 *        )
 *      )
 *   }
 * )
 */

 class SearchResponse { }