<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="UserProfileUpdate",
 *     description="User Profile Update Schema",
 *     title="User Profile Update",
 * )
 */

class UserProfileUpdate { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Name",
     *     title="Name",
     * )
     *
     */
    private $name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Email",
     *     title="Email",
     * )
     *
     */
    private $email;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Country ISD code",
     *     title="Country ISD code",
     *     nullable=true
     * )
     *
     */
    private $isd_code;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Mobile",
     *     title="Mobile",
     *     nullable=true
     * )
     *
     */
    private $mobile;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="user profile image",
     *     title="Profile image",
     * )
     *
     */
    private $profile_image;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="profile is completed or not",
     *     title="Is Profile Completed",
     * )
     *
     */
    private $is_profile_completed;

     /**
     * @OA\Property(
     *     type="integer",
     *     description="completed step of regitration",
     *     title="Step",
     * )
     *
     */
    private $step;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="user is verified or not",
     *     title="Is Verified",
     * )
     *
     */
    private $is_verified;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="is login type 0=Normal, 1=Google, 2=Facebook, 3=Twitter, 4=Apple",
     *     title="Login Type",
     * )
     *
     */
    private $login_type;

    /**
     * @OA\Property(
     *     type="string",
     *     description="is social id of social login user",
     *     title="Social Id",
     * )
     *
     */
    private $social_id;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="check for the driver account is subscribed or not if 1 then subscribed ,0 then not",
     *     title="Is Subscribed",
     * )
     *
     */
    private $is_subscribed;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver rating",
     *     title="Rating",
     * )
     *
     */
    private $rating;

    /**
     * @OA\Property(
     *     type="string",
     *     description="user stripe id",
     *     title="Stripe Id",
     * )
     *
     */
    private $stripe_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="user send bird chat id",
     *     title="Sendbird chat ID",
     * )
     *
     */
    private $sendbird_chat_id;
}