<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="PlanData",
 *     description="Get Plan Schema",
 *     title="Plan Data",
 * )
 */

class PlanData { 

    /**
     * @OA\Property(
     *     type="string",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="subscription name",
     *     title="Subscription name",
     * )
     *
     */
    private $subscription_name;

    /**
     * @OA\Property(
     *     type="number",
     *     format="float",
     *     description="price",
     *     title="Price",
     * )
     *
     */
    private $price;

    /**
     * @OA\Property(
     *     type="string",
     *     description="subscription type",
     *     title="Subscription Type",
     * )
     *
     */
    private $subscription_type;

    /**
     * @OA\Property(
     *     type="string",
     *     description="expire days",
     *     title="Expiry Days",
     * )
     *
     */
    private $exp_days;

    /**
     * @OA\Property(
     *     type="string",
     *     description="expire date",
     *     title="Expiry Date",
     * )
     *
     */
    private $exp_date;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="is active",
     *     title="Plan Active",
     * )
     *
     */
    private $is_active;
    

}