<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="PaginationResponseObjectFields",
 *     description="Pagination Response Object Fields Schema",
 *     title="Pagination Data",
 * )
 */

class PaginationResponseObjectFields { 

    /**
     * @OA\Property(
     *     type="integer",
     *     description="current page",
     *     title="Current Page",
     * )
     *
     */
    private $curent_page;

     /**
     * @OA\Property(
     *     type="integer",
     *     description="per page",
     *     title="Per Page",
     * )
     *
     */
    private $per_page;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="total",
     *     title="Total",
     * )
     *
     */
    private $total;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="total page",
     *     title="Total Page",
     * )
     *
     */
    private $total_page;

}