<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetReceivedBidData",
 *     description="Get Received Bid Schema",
 *     title="Received Bid Data",
 * )
 */

class GetReceivedBidData {

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Bid id",
     *     title="BID ID",
     * )
     *
     */
    private $bid_id;

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Booking ID",
     *     title="Booking ID",
     * )
     *
     */
    private $booking_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="miles",
     *     title="Miles",
     * )
     *
     */
    private $miles;
    
    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="user submitted amount",
     *     title="User Submitted Amount",
     * )
     *
     */
    private $submitted_price;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="driver bid amount",
     *     title="Driver Bid Amount",
     * )
     *
     */
    private $driver_bid_amount;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="user bid amount",
     *     title="User Bid Amount",
     * )
     *
     */
    private $user_bid_amount;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Driver ID",
     *     title="Driver ID",
     * )
     *
     */
    private $driver_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver image URL",
     *     title="Driver Image",
     * )
     *
     */
    private $driver_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver name",
     *     title="Driver Name",
     * )
     *
     */
    private $driver_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver vehicle",
     *     title="Driver Vehicle",
     * )
     *
     */
    private $driver_vehicle;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver rating",
     *     title="Driver Rating",
     * )
     *
     */
    private $driver_rating;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Date and time",
     *     title="Date and Time",
     * )
     *
     */
    private $date_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Bid Expire time",
     *     title="Bid Expire time",
     * )
     *
     */
    private $bid_expire_time;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="Booking scheduled",
     *     title="Is Scheduled",
     * )
     *
     */
    private $is_scheduled;
}