<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetQuoteDetailData",
 *     description="Get Quote Detail Schema",
 *     title="Quote Detail Data",
 * )
 */

class GetQuoteDetailData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="the date when company quoted price",
     *     title="Quote Date Time",
     * )
     *
     */
    private $quote_date_time;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul image",
     *     title="Image",
     * )
     *
     */
    private $air_transportation_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul name",
     *     title="Name",
     * )
     *
     */
    private $air_transportation_name;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation sendbird chat id for chat",
     *     title="SendBird Chat ID",
     * )
     *
     */
    private $air_transportation_chat_id;

     /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul mobile number",
     *     title="Mobile number",
     * )
     *
     */
    private $air_transportation_phone_no;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="adult passenger",
     *     title="Adult",
     * )
     *
     */
    private $adult;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="child passenger",
     *     title="Child",
     * )
     *
     */
    private $child;

    /**
     * @OA\Property(
     *     type="string",
     *     description="flying type of booking",
     *     title="Flying Type",
     * )
     *
     */
    private $flying_type;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="trip type of booking",
     *     title="Trip Type",
     * )
     *
     */
    private $trip_type;
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the departure time for booking",
     *     title="Departure Date Time",
     * )
     *
     */
    private $departure_date_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the arrival time for booking",
     *     title="Arrival Date Time",
     * )
     *
     */
    private $arrival_date_time;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="the company quoted price",
     *     title="Company Quote Price",
     * )
     *
     */
    private $quotation;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the user quoted price",
     *     title="User Quote Price",
     * )
     *
     */
    private $user_quote_price;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="quote status",
     *     title="User Quote Status",
     * )
     *
     */
    private $quote_status;

    /**
     * @OA\Property(
     *     type="string",
     *     description="comment of user on booking",
     *     title="Comment",
     * )
     *
     */
    private $comment;
    
    
}