<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetQuoteData",
 *     description="Get Quote Schema",
 *     title="Quote Data",
 * )
 */

class GetQuoteData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the date when company quoted price",
     *     title="Quote Date Time",
     * )
     *
     */
    private $quote_date_time;

     /**
     * @OA\Property(
     *     type="string",
     *     description="the company quoted price",
     *     title="Company Quote Price",
     * )
     *
     */
    private $company_quote_price;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul image",
     *     title="Image",
     * )
     *
     */
    private $air_transportation_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul name",
     *     title="Name",
     * )
     *
     */
    private $air_transportation_name;

     /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation sendbird chat id for chat",
     *     title="SendBird Chat ID",
     * )
     *
     */
    private $air_transportation_chat_id;

     /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul mobile number",
     *     title="Mobile number",
     * )
     *
     */
    private $air_transportation_phone_no;
}