<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetNotificationData",
 *     description="Get Notification Schema",
 *     title="Notification Data",
 * )
 */

class GetNotificationData { 

    /**
     * @OA\Property(
     *     type="number",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="notificaiton title",
     *     title="Notification Title",
     * )
     *
     */
    private $notification_title;

    /**
     * @OA\Property(
     *     type="string",
     *     description="notification description",
     *     title="Notification Description",
     * )
     *
     */
    private $notification_desc;

    /**
     * @OA\Property(
     *     type="string",
     *     description="notification time",
     *     title="Notification Time",
     * )
     *
     */
    private $notification_time;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="notification object id",
     *     title="Notification Object Id",
     * )
     *
     */
    private $notification_object_id;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="notification object type",
     *     title="Notification Object Type",
     * )
     *
     */
    private $notification_object_type;

    /**
     * @OA\Property(
     *     type="string",
     *     description="notification icon",
     *     title="Notification Icon",
     * )
     *
     */
    private $notification_icon;
    
}
