<?php

namespace Swagger\APIs\v1\Schemas;

/**
 * @OA\Schema(
 *     schema="GetDriverTaxiBookingData",
 *     description="Get Driver Taxi Booking Schema",
 *     title="Driver Taxi Booking Data",
 * )
 */
class GetDriverTaxiBookingData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;
 
    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off location",
     *     title="Drop-off Location",
     * )
     *
     */
    private $dropoff_location;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="booking date and time",
     *     title="Booking Date and Time",
     * )
     *
     */
    private $booking_date_time;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="booking amount",
     *     title="Booking Amount",
     * )
     *
     */
    private $booking_amount;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="is scheduled",
     *     title="Is Scheduled",
     * )
     *
     */
    private $is_scheduled;

    /**
     * @OA\Property(
     *     type="string",
     *     description="scheduled time",
     *     title="Scheduled Time",
     * )
     *
     */
    private $scheduled_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="start button time",
     *     title="Start button time",
     * )
     *
     */
    private $start_button_time;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="booking status",
     *     title="Booking Status",
     * )
     *
     */
    private $booking_status;

    
    /**
     * @OA\Property(
     *     type="string",
     *     description="user image URL",
     *     title="User Image",
     * )
     *
     */
    private $user_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="user name",
     *     title="User Name",
     * )
     *
     */
    private $user_name;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="user chat ID",
     *     title="User Chat ID",
     * )
     *
     */
    private $user_chat_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="user phone number",
     *     title="User Phone Number",
     * )
     *
     */
    private $user_phone_no;

}
