<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetCustomerRequestData",
 *     description="Get Customer Request Schema",
 *     title="Customer Request Data",
 * )
 */
class GetCustomerRequestData
{
    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Bid ID",
     *     title="Bid ID",
     * )
     *
     */
    private $bid_id;

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Booking ID",
     *     title="Booking ID",
     * )
     *
     */
    private $booking_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="Miles",
     *     title="Miles",
     * )
     *
     */
    private $miles;
     
    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="user submitted amount",
     *     title="User Submitted Amount",
     * )
     *
     */
    private $submitted_price;


    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="User bid amount",
     *     title="User Bid Amount",
     * )
     *
     */
    private $user_bid_amount;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="Driver bid amount",
     *     title="Driver Bid Amount",
     * )
     *
     */
    private $driver_bid_amount;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User image URL",
     *     title="User Image",
     * )
     *
     */
    private $user_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User name",
     *     title="User Name",
     * )
     *
     */
    private $user_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User vehicle",
     *     title="User Vehicle",
     * )
     *
     */
    private $user_vehicle;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Date and time",
     *     title="Date and Time",
     * )
     *
     */
    private $date_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Bid Expire time",
     *     title="Bid Expire time",
     * )
     *
     */
    private $bid_expire_time;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="Booking scheduled",
     *     title="Is Scheduled",
     * )
     *
     */
    private $is_scheduled;
}
