<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetCurrentBookingDetailData",
 *     description="Get Current Booking Detail Schema",
 *     title="Current Booking Detail Data",
 * )
 */
class GetCurrentBookingDetailData
{
     /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Booking ID",
     *     title="Booking ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="Driver ID",
     *     title="Driver ID",
     * )
     *
     */
    private $driver_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup latitude",
     *     title="Pickup Latitude",
     * )
     *
     */
    private $pickup_lat;

    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup longitude",
     *     title="Pickup Longitude",
     * )
     *
     */
    private $pickup_long;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off latitude",
     *     title="Drop-off Latitude",
     * )
     *
     */
    private $dropoff_lat;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off longitude",
     *     title="Drop-off Longitude",
     * )
     *
     */
    private $dropoff_long;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="Miles",
     *     title="Miles",
     * )
     *
     */
    private $miles;
     
    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="booking amount",
     *     title="Booking Amount",
     * )
     *
     */
    private $booking_amount;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User image URL",
     *     title="User Image",
     * )
     *
     */
    private $profile_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User name",
     *     title="User Name",
     * )
     *
     */
    private $name;
    
     /**
     * @OA\Property(
     *     type="string",
     *     description="Sendbird chat id",
     *     title="Send Bird Chat ID",
     * )
     *
     */
    private $sendbird_chat_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User mobile",
     *     title="User Mobile",
     * )
     *
     */
    private $mobile;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User vehicle",
     *     title="User Vehicle",
     * )
     *
     */
    private $vehicle_name;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="driver rating",
     *     title="Driver Rating",
     * )
     *
     */
    private $rating;
    
     /**
     * @OA\Property(
     *     type="string",
     *     description="arrival date and time",
     *     title="Arrival Date and Time",
     * )
     *
     */
    private $booking_arrival_time;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="booking status",
     *     title="Booking Status",
     * )
     *
     */
    private $booking_status;
}
