<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetCardData",
 *     description="Get Card Schema",
 *     title="Card Data",
 * )
 */

class GetCardData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="card holder name",
     *     title="Card Holder Name",
     * )
     *
     */
    private $card_holder_name;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="card fingerprint",
     *     title="Card Fingerprint",
     * )
     *
     */
    private $fingerprint;

    /**
     * @OA\Property(
     *     type="string",
     *     description="card id",
     *     title="Card ID",
     * )
     *
     */
    private $card_token;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="card brand",
     *     title="Card Brand",
     * )
     *
     */
    private $brand;

    /**
     * @OA\Property(
     *     type="string",
     *     description="card number",
     *     title="Card Number",
     * )
     *
     */
    private $card_number;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="card expiry month",
     *     title="Card Expiry Month",
     * )
     *
     */
    private $exp_month;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="card expiry year",
     *     title="Card Expiry YEar",
     * )
     *
     */
    private $exp_year;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="shows the card is  default or not",
     *     title="Is Default",
     * )
     *
     */
    private $is_default;

     /**
     * @OA\Property(
     *     type="string",
     *     description="shows the card brand image",
     *     title="card_image",
     * )
     *
     */
    private $card_image;

}