<?php

namespace Swagger\APIs\v1\Schemas;

/**
 * @OA\Schema(
 *     schema="GetBookingData",
 *     description="Get Booking Schema",
 *     title="Booking Data",
 * )
 */
class GetBookingData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $driver_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking date and time",
     *     title="Booking Date and Time",
     * )
     *
     */
    private $booking_date_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="profile image URL",
     *     title="Profile Image",
     * )
     *
     */
    private $profile_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="name",
     *     title="Name",
     * )
     *
     */
    private $name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver rating",
     *     title="Driver Rating",
     * )
     *
     */
    private $driver_rating;

    /**
     * @OA\Property(
     *     type="string",
     *     description="sendbird chat ID",
     *     title="Sendbird Chat ID",
     * )
     *
     */
    private $sendbird_chat_id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="phone number",
     *     title="Phone Number",
     * )
     *
     */
    private $mobile_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="driver vehicle number",
     *     title="Driver Vehicle Number",
     * )
     *
     */
    private $vehicle_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle name",
     *     title="Vehicle Name",
     * )
     *
     */
    private $vehicle_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off location",
     *     title="Drop-off Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup latitude",
     *     title="Pickup Latitude",
     * )
     *
     */
    private $pickup_lat;

    /**
     * @OA\Property(
     *     type="string",
     *     description="pickup longitude",
     *     title="Pickup Longitude",
     * )
     *
     */
    private $pickup_long;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off latitude",
     *     title="Drop-off Latitude",
     * )
     *
     */
    private $dropoff_lat;

    /**
     * @OA\Property(
     *     type="string",
     *     description="drop-off longitude",
     *     title="Drop-off Longitude",
     * )
     *
     */
    private $dropoff_long;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="miles",
     *     title="Miles",
     * )
     *
     */
    private $miles;
    
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="user rate given",
     *     title="user rate given",
     * )
     *
     */
    private $rate_given;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="booking rating",
     *     title="booking rating",
     * )
     *
     */
    private $booking_rating;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="booking amount",
     *     title="Booking Amount",
     * )
     *
     */
    private $booking_amount;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="is scheduled",
     *     title="Is Scheduled",
     * )
     *
     */
    private $is_scheduled;

    /**
     * @OA\Property(
     *     type="string",
     *     description="scheduled time",
     *     title="Scheduled Time",
     * )
     *
     */
    private $scheduled_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="start button time",
     *     title="Start button time",
     * )
     *
     */
    private $start_button_time;


    /**
     * @OA\Property(
     *     type="integer",
     *     description="booking status",
     *     title="Booking Status",
     * )
     *
     */
    private $booking_status;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking cancelled by",
     *     title="Booking Cancelled By",
     * )
     *
     */
    private $booking_cancelled_by;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking cancel reason",
     *     title="Booking Cancel Reason",
     * )
     *
     */
    private $booking_cancel_reason;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="tip amount",
     *     title="Booking Tip Amount",
     * )
     *
     */
    private $booking_tip;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="waiting charge amount",
     *     title="Waiting Charge Amount",
     * )
     *
     */
    private $booking_waiting_charge;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="driver fare",
     *     title="Booking Driver Fare",
     * )
     *
     */
    private $driver_fare;
}
