<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetAirTransportBookingDetailData",
 *     description="Get Air Transport Booking Detail Schema",
 *     title="Get Air Transport Booking Detail Data",
 * )
 */

class GetAirTransportBookingDetailData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="booking number",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport booking date and time",
     *     title="Booking Date Time",
     * )
     *
     */
    private $booking_date_time;    

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport pickup location",
     *     title="Pickup Location",
     * )
     *
     */
    private $pickup_location;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transport dropoff location",
     *     title="Dropoff Location",
     * )
     *
     */
    private $dropoff_location;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="adult passenger",
     *     title="Adult",
     * )
     *
     */
    private $adult;
    
     /**
     * @OA\Property(
     *     type="integer",
     *     description="child passenger",
     *     title="Child",
     * )
     *
     */
    private $child;

     /**
     * @OA\Property(
     *     type="string",
     *     description="flying type of booking",
     *     title="Flying Type",
     * )
     *
     */
    private $flying_type;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="trip type of booking",
     *     title="Trip Type",
     * )
     *
     */
    private $trip_type;
    /**
     * @OA\Property(
     *     type="string",
     *     description="the departure time for booking",
     *     title="Departure Date Time",
     * )
     *
     */
    private $departure_date_time;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the arrival time for booking",
     *     title="Arrival Date Time",
     * )
     *
     */
    private $arrival_date_time;
    
    

    /**
     * @OA\Property(
     *     type="string",
     *     description="comment of user on booking",
     *     title="Comment",
     * )
     *
     */
    private $comment;
    
    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul image",
     *     title="Image",
     * )
     *
     */
    private $air_transportation_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="air transportation company/individaul name",
     *     title="Name",
     * )
     *
     */
    private $air_transportation_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the booking price",
     *     title="Booking Price",
     * )
     *
     */
    private $booking_price;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="the booking status",
     *     title="Booking Status",
     * )
     *
     */
    private $booking_status;
    
    /**
     * @OA\Property(
     *     type="integer",
     *     description="booking is rated or not",
     *     title="Booking Rating Status",
     * )
     *
     */
    private $is_rated;

    /**
     * @OA\Property(
     *     type="string",
     *     description="the booking cancel reason",
     *     title="Cancel Reason",
     * )
     *
     */
    private $cancel_reason;
}