<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="GetAddressData",
 *     description="Get Address Schema",
 *     title="Address Data",
 * )
 */

class GetAddressData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     format="int64",
     *     description="ID",
     *     title="ID",
     * )
     *
     */
    private $id;

    /**
     * @OA\Property(
     *     type="string",
     *     description="apartment name",
     *     title="Apartment name",
     * )
     *
     */
    private $apartment_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="street address",
     *     title="Street address",
     * )
     *
     */
    private $street_address;

    /**
     * @OA\Property(
     *     type="string",
     *     description="city name",
     *     title="City",
     * )
     *
     */
    private $city;

    /**
     * @OA\Property(
     *     type="string",
     *     description="postal_code",
     *     title="Postal code",
     * )
     *
     */
    private $postal_code;

    

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="latitude",
     *     title="latitude",
     * )
     *
     */
    private $add_lat;

    /**
     * @OA\Property(
     *     type="number",
     *     format="double",
     *     description="longitude",
     *     title="longitude",
     * )
     *
     */
    private $add_long;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="address_type",
     *     title="Address type",
     * )
     *
     */
    private $address_type;

     /**
     * @OA\Property(
     *     type="string",
     *     description="address_text",
     *     title="Address Text",
     * )
     *
     */
    private $address_text;

}