<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="DriverVehicleInfoData",
 *     description="Get Driver Vehicle Images Schema",
 *     title="Driver Vehicle Info Data",
 * )
 */

class DriverVehicleInfoData { 

    /**
     * @OA\Property(
     *     type="integer",
     *     description="vehicle type",
     *     title="Vehicle Type",
     * )
     *
     */
    private $vehicle_type;

   
    

    /**
     * @OA\Property(
     *     type="string",
     *     description="plate number",
     *     title="Plate Number",
     * )
     *
     */
    private $plate_number;

    /**
     * @OA\Property(
     *     type="string",
     *     description="model name",
     *     title="Model name",
     * )
     *
     */
    private $model_name;

    /**
     * @OA\Property(
     *     type="string",
     *     description="model number",
     *     title="Model number",
     * )
     *
     */
    private $model_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle color",
     *     title="Vehicle color",
     * )
     *
     */
    private $color;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle identification no",
     *     title="Vehicle identification number",
     * )
     *
     */
    private $identification_no;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="model year",
     *     title="Vehicle model year",
     * )
     *
     */
    private $model_year;

    /**
     * @OA\Property(
     *     type="integer",
     *     description="vehicle seating capacity",
     *     title="Vehicle seating capacity",
     * )
     *
     */
    private $seating_capacity;

}