<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="DriverVehicleData",
 *     description="Get Driver Vehicle Images Schema",
 *     title="Driver Vehicle Data",
 * )
 */

class DriverVehicleData { 

    /**
     * @OA\Property(
     *     type="string",
     *     description="registration proof file",
     *     title="Registration file",
     * )
     *
     */
    private $registration_proof_file;

   
    

    /**
     * @OA\Property(
     *     type="string",
     *     description="insurance proof file",
     *     title="Insurance file",
     * )
     *
     */
    private $insurance_proof_file;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle front image",
     *     title="Vehicle front image",
     * )
     *
     */
    private $vehicle_front_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle back image",
     *     title="Vehicle back image",
     * )
     *
     */
    private $vehicle_back_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle right image",
     *     title="Vehicle right image",
     * )
     *
     */
    private $vehicle_right_image;

    /**
     * @OA\Property(
     *     type="string",
     *     description="vehicle left image",
     *     title="Vehicle left image",
     * )
     *
     */
    private $vehicle_left_image;

}