<?php

namespace Swagger\APIs\v1\Schemas;

/**
 *
 * @author  Mohammad Haris <harishr.spaceo@gmail.com>
 *
 * @OA\Schema(
 *     schema="DriverEarningsListData",
 *     description="Get Driver Earning List Schema",
 *     title="Driver Earning List Data",
 * )
 */

class DriverEarningsListData { 

    /**
     * @OA\Property(
     *     type="string",
     *     description="Booking No",
     *     title="Booking Number",
     * )
     *
     */
    private $booking_no;

    /**
     * @OA\Property(
     *     type="string",
     *     description="User Name",
     *     title="User Name",
     * )
     *
     */
    private $user_name;

    /**
     * @OA\Property(
     *     type="number",
     *     format="float",
     *     description="Payment Amount",
     *     title="Payment Amount",
     * )
     *
     */
    private $amount;

    /**
     * @OA\Property(
     *     type="string",
     *     description="Payment Date Time",
     *     title="Payment Date Time",
     * )
     *
     */
    private $datetime;

     /**
     * @OA\Property(
     *     type="integer",
     *     description="Payment Status",
     *     title="Payment Status",
     * )
     *
     */
    private $status;

}