<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/register",
 *     tags={"User Authentication"},
 *     summary="Make the user register.",
 *     operationId="register",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                      "social_type",
 *                      "name", 
 *                      "email", 
 *                      "isd_code", 
 *                      "mobile", 
 *                      "dob",
 *                      "gender",
 *                      "device_type",
 *                      "device_name",
 *                      "device_id",
 *                 },
 *                 @OA\Property(
 *                     property="social_type", 
 *                     type="integer",
 *                     description="0=Normal, 1=Google, 2=Facebook, 3=Twitter, 4=Apple"
 *                 ),
 *                 @OA\Property(
 *                     property="social_id", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="profile_photo", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="name", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="email", 
 *                     type="string",
 *                     format="email",
 *                 ),
 *                 @OA\Property(
 *                     property="isd_code", 
 *                     type="string",
 *                     example="+91"
 *                 ),
 *                 @OA\Property(
 *                     property="mobile", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="password", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="dob", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="gender", 
 *                     type="integer",
 *                     description="1=Male, 2=Female, 3=Prefer not to say"
 *                 ),
 *                 @OA\Property(
 *                     property="device_type", 
 *                     type="string", 
 *                     enum={"ios","android","web"},
 *                 ),
 *                 @OA\Property(
 *                     property="device_name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_id", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_token", 
 *                     type="string"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/LoginResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 *
 */

class Register
{
    
}
