<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Put(
 *     path="/token/refresh",
 *     tags={"User Authentication"},
 *     summary="Refresh the user's access token",
 *     operationId="tokenRefresh",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="Refresh-Token",
 *         description="Refresh Token",
 *         in="header",
 *         required=true,
 *         @OA\Schema(
 *             type="string"
 *         )
 *     ),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"device_type", "device_name", "device_id"},
 *                 @OA\Property(
 *                     property="device_type", 
 *                     type="string", 
 *                     enum={"ios","android","web"},
 *                 ),
 *                 @OA\Property(
 *                     property="device_name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_id", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_token", 
 *                     type="string"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/RefreshTokenResponse"),
 *     ),
 *     @OA\Response(response=401, ref="#/components/responses/Unauthorized"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="RefreshTokenResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/RefreshTokenData"
 *          )
 *      )
 *   }
 * )
 * 
 * @OA\Schema(
 *   schema="RefreshTokenData",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Token"),
 *   }
 * )
 */

class RefreshToken
{
    
}
