<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/login",
 *     tags={"User Authentication"},
 *     summary="Make the user login.",
 *     operationId="login",
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"username", "password", "user_type", "device_type", "device_name", "device_id"},
 *                 @OA\Property(
 *                     property="username", 
 *                     type="string",
 *                     description="username can either be email, mobile number or username. mobile must be prefix with country code i.e. +91 xxxxxxxxxx"
 *                 ),
 *                 @OA\Property(
 *                     property="password", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="user_type", 
 *                     type="integer", 
 *                     description="1 = customer,2 = driver",
 *                 ),
 *                 @OA\Property(
 *                     property="device_type", 
 *                     type="string", 
 *                     enum={"ios","android","web"},
 *                 ),
 *                 @OA\Property(
 *                     property="device_name", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_id", 
 *                     type="string"
 *                 ),
 *                 @OA\Property(
 *                     property="device_token", 
 *                     type="string"
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/LoginResponse"),
 *     ),
 *     @OA\Response(response=401, ref="#/components/responses/Unauthorized"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="LoginResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/LoginData"
 *          )
 *      )
 *   }
 * )
 * 
 * @OA\Schema(
 *   schema="LoginData",
 *   type="object",
 *   allOf={
 *     @OA\Schema(
 *          @OA\Property(
 *              property="user", 
 *              type="object",
 *              ref="#/components/schemas/User"
 *          ),
 *          @OA\Property(
 *              property="is_already_logged_in", 
 *              type="boolean",
 *          ),
 *         @OA\Property(
 *              property="is_social_register", 
 *              type="integer",
 *          )
 * 
 *      ),
 *     @OA\Schema(ref="#/components/schemas/Token"),
 *   }
 * )
 */

 class Login { }