<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_help_topics/{type}",
 *     tags={"Settings"},
 *     summary="Get help topics.",
 *     operationId="helpTopic",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="type",
 *         description="",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *             
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/HelpTopicResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 *@OA\Schema(
 *   schema="HelpTopicResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *              @OA\Items(
 *                  type="object",
 *                  ref="#/components/schemas/HelpTopicData"
 *              )            
 *          )
 *      )
 *   }
 * )
 */

 class HelpTopic { }