<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/rate_airtransportation",
 *     tags={"Air Transportation Module"},
 *     summary="give rate and review to air transport booking.",
 *     operationId="giveAirReview",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"booking_id","rating"},
 *                 @OA\Property(
 *                     property="booking_id", 
 *                     type="integer",
 *                 ),
 *                 @OA\Property(
 *                     property="review", 
 *                     type="string",
 *                 ),
 *                 @OA\Property(
 *                     property="rating", 
 *                     type="integer",
 *                 ),
 *                 
 *             )
 *         )
 *     ),
 * 
 *     @OA\Response(response=200, ref="#/components/responses/OK"),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 */

 class GiveAirTransportReview { }