<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/user/get_addresses",
 *     tags={"User Addresses"},
 *     summary="Get the user addresses.",
 *     operationId="getUserAddress",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetUserAddressesResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetUserAddressesResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *              @OA\Items(
 *                  type="object",
 *                  ref="#/components/schemas/GetAddressData"
 *              ),
 *              
 *          )
 *      )
 *   }
 * )
 */

 class GetUserAddress { }