<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_terminals",
 *     tags={"Air Transportation Module"},
 *     summary="Get terminals for pickup and dropoff location.",
 *     operationId="getTerminal",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetTerminalResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 *@OA\Schema(
 *   schema="GetTerminalResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              @OA\Property(
 *              property="pickup", 
 *              type="array",
 *              @OA\Items(
 *                   type="string"
 *              ),
 *          ),
 *              @OA\Property(
 *              property="dropoff", 
 *              type="array",
 *              @OA\Items(
 *                   type="string"
 *              ),
 *          )
 *        )
 *      )
 *   }
 * )
 */

 class GetTerminal { }