<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/get_bookings",
 *     tags={"Booking Module"},
 *     summary="Get the driver taxi booking.",
 *     operationId="getTaxiDriverBookings",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={"status","offset","page"},
 *                 @OA\Property(
 *                     property="status", 
 *                     type="integer",
 *                     description="1=upcoming, 2=completed, 3=cancelled"
 *                 ),
 *                 @OA\Property(
 *                     property="offset", 
 *                     type="integer",
 *                     
 *                 ),
 *                @OA\Property(
 *                     property="page", 
 *                     type="integer",
 *                    
 *                 )
 *             )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetTaxiDriverBookingResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetTaxiDriverBookingResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetDriverTaxiBookingData"
 *              )
 *          ),
 *          @OA\Property(
 *              property="pagination", 
 *              type="object",
 *              ref="#/components/schemas/PaginationResponseObjectFields"
 *          ),
 *      )
 *   }
 * )
 */

 class GetTaxiDriverBooking { }