<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_quotes/{offset}/{page}",
 *     tags={"Air Transportation Module"},
 *     summary="Get the user air transport booking quotes.",
 *     operationId="getQuotes",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Parameter(
 *         name="offset",
 *         description="",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *             
 *         )
 *     ),
 *     @OA\Parameter(
 *         name="page",
 *         description="",
 *         in="path",
 *         required=true,
 *         @OA\Schema(
 *              type="integer",
 *             
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetQuotesResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetQuotesResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetQuoteData"
 *              )
 *          ),
 *         @OA\Property(
 *              property="pagination", 
 *              type="object",
 *              ref="#/components/schemas/PaginationResponseObjectFields"
 *          ),
 *      ),
 * 
 *   }
 * ),
 * 
 */

 class GetQuotes { }