<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/get_notification_list",
 *     tags={"Notification Module"},
 *     summary="Get the user notification list.",
 *     operationId="getNotification",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetNotificationResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetNotificationResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetNotificationData"
 *              )
 *          )
 *      )
 *   }
 * )
 */

 class GetNotification { }
