<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/get_nearby_drivers",
 *     tags={"Booking Module"},
 *     summary="Get the nearby driver.",
 *     operationId="getNearbyDriver",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "latitude","longitude"
 *                      },
 *                 @OA\Property(
 *                     property="latitude", 
 *                     type="string",
 *                 ), 
 *                 @OA\Property(
 *                     property="longitude", 
 *                     type="string",
 *                 ),                     
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetNearbyDriverResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetNearbyDriverResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              @OA\Property(
 *                    property="user_id", 
 *                    type="integer",
 *              ),
 *              @OA\Property(
 *                    property="notification_count", 
 *                    type="integer",
 *              ),
 *              @OA\Property(
 *                    property="quotes_count", 
 *                    type="integer",
 *              ),
 *              @OA\property(
 *                    property="drivers",
 *                    type="array",
 *                    @OA\Items(ref="#/components/schemas/NearbyDriverFields")
 *              ),
 *         )
 *      )
 *      
 *   }
 * )
 */

class GetNearbyDriver
{
}