<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/get_home_details",
 *     tags={"Driver Profile"},
 *     summary="get some home details of the driver.",
 *     operationId="getHomeDetails",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *         response=200,
 *         description="Successful operation",
 *         @OA\JsonContent(ref="#/components/schemas/GetHomeDetailsResponse"),
 *     ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 *  @OA\Schema(
 *   schema="GetHomeDetailsResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              type="object",
 *              ref="#/components/schemas/GetHomeDetailsData"
 *          )
 *      )
 *   }
 * )
 */

 class GetHomeDetails { }
