<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Get(
 *     path="/flying-types",
 *     tags={"Air Transportation Module"},
 *     summary="Get the flying type.",
 *     operationId="getFlyingType",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetFlyingTypeResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetFlyingTypeResponse",
 *   type="object",
 *   allOf={
 *    
 *     @OA\Schema(
 *          @OA\Property(
 *              property="flying_types", 
 *              type="array",
 *          @OA\Items(
 *              ref="#/components/schemas/GetFlyingTypeData"
 *          )
 *        )
 *      )
 *   }
 * )
 */

 class GetFlyingType { }