<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/get_earning_list_data",
 *     tags={"Booking Module"},
 *     summary="Get the driver booking earning data for list.",
 *     operationId="getEarningList",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             
 *             @OA\Schema(
 *                  required={
 *                        "filter_type",
 *                      },
 *                 @OA\Property(
 *                     property="filter_type", 
 *                     type="integer",
 *                     description="1 = weekly, 2 = monthly, 3 = yearly, 4=range",
 *                 ),
 *                 @OA\Property(
 *                     property="filter_option", 
 *                     type="integer",
 *                     description="1 = pending, 2 = received",
 *                 ),
 *                 @OA\Property(
 *                     property="from_date", 
 *                     type="string",
 *                     description ="2023-10-01"
 *                 ),
 *                 @OA\Property(
 *                     property="to_date", 
 *                     type="string",
 *                     description ="2023-10-13"
 *                 ),
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetEarningListResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetEarningListResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              @OA\property(
 *                    property="list",
 *                    type="array",
 *                    @OA\Items(ref="#/components/schemas/DriverEarningsListData")
 *              ),
 *              @OA\Property(
 *                    property="grand_total_amount", 
 *                    type="number",
 *                    format="float"
 *              ),
 *              @OA\Property(
 *                    property="total_received_amount", 
 *                    type="number",
 *                    format="float"
 *              ),
 *          )
 *      )
 *   }
 * )
 */

class GetEarningList
{
}