<?php

namespace Swagger\APIs\v1;

/**
 * @OA\Post(
 *     path="/driver/get_earning_graph_data",
 *     tags={"Booking Module"},
 *     summary="Get the driver booking earning data for graph.",
 *     operationId="getEarningGraph",
 *     security={{ "bearerAuth":{} }},
 *     @OA\Parameter(ref="#/components/parameters/Accept"),
 *     @OA\Parameter(ref="#/components/parameters/Accept-Language"),
 *     @OA\RequestBody(
 *         description="Input data format",
 *         @OA\MediaType(
 *             mediaType="application/x-www-form-urlencoded",
 *             @OA\Schema(
 *                 required={
 *                        "filter_type",
 *                      },
 *                 @OA\Property(
 *                     property="filter_type", 
 *                     type="integer",
 *                     description="1 = weekly, 2 = monthly, 3 = yearly",
 *                 ),                 
 *              )
 *         )
 *     ),
 *     @OA\Response(
 *          response=200,
 *          description="Successful operation",
 *          @OA\JsonContent(ref="#/components/schemas/GetEarningGraphResponse"),
 *      ),
 *     @OA\Response(response=422, ref="#/components/responses/UnprocessableEntity"),
 *     @OA\Response(response=500, ref="#/components/responses/InternalServerError"),
 *     @OA\Response(response=503, ref="#/components/responses/ServiceUnavailable"),
 * )
 * 
 * @OA\Schema(
 *   schema="GetEarningGraphResponse",
 *   type="object",
 *   allOf={
 *     @OA\Schema(ref="#/components/schemas/Message"),
 *     @OA\Schema(
 *          @OA\Property(
 *              property="data", 
 *              @OA\property(
 *                    property="list",
 *                    type="array",
 *                    @OA\Items(ref="#/components/schemas/DriverEarningsStatisticsFields")
 *              ),
 *              @OA\Property(
 *                    property="grand_total_amount", 
 *                    type="number",
 *                    format="float"
 *              ),
 *              @OA\Property(
 *                    property="total_received_amount", 
 *                    type="number",
 *                    format="float"
 *              ),
 *          )
 *      )
 *   }
 * )
 */

class GetEarningGraph
{
}